@echo off
:: https://privacy.sexy — v0.13.8 — Sat, 11 Oct 2025 16:24:24 GMT
:: Ensure PowerShell is available
where PowerShell >nul 2>&1 || (
    echo PowerShell is not available. Please install or enable PowerShell.
    pause & exit 1
)
:: Ensure admin privileges
fltmc >nul 2>&1 || (
    echo Administrator privileges are required.
    PowerShell Start -Verb RunAs '%0' 2> nul || (
        echo Right-click on the script and select "Run as administrator".
        pause & exit 1
    )
    exit 0
)
:: Initialize environment
setlocal EnableExtensions DisableDelayedExpansion


:: Disable Microsoft Account Sign-in Assistant (breaks Microsoft Store and Microsoft Account sign-in) (revert)
echo --- Disable Microsoft Account Sign-in Assistant (breaks Microsoft Store and Microsoft Account sign-in) (revert)
:: Restore service(s) to default state: `wlidsvc`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'wlidsvc'; $defaultStartupMode = 'Manual'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---------Disable Downloaded Maps Manager (revert)---------
:: ----------------------------------------------------------
echo --- Disable Downloaded Maps Manager (revert)
:: Restore service(s) to default state: `MapsBroker`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'MapsBroker'; $defaultStartupMode = 'Automatic'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----------Disable Microsoft Retail Demo (revert)----------
:: ----------------------------------------------------------
echo --- Disable Microsoft Retail Demo (revert)
:: Restore service(s) to default state: `RetailDemo`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'RetailDemo'; $defaultStartupMode = 'Manual'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------------Disable User Data Access (revert)-------------
:: ----------------------------------------------------------
echo --- Disable User Data Access (revert)
:: Restore per-user "UserDataSvc" service to its default configuration for all users
:: Restore the service `UserDataSvc` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'UserDataSvc'; $defaultStartupMode = 'Manual'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: Restore per-user "UserDataSvc" service to its default configuration for individual user accounts
:: Restore the service `UserDataSvc_*` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'UserDataSvc_*'; $defaultStartupMode = 'Manual'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------------Disable Messaging Service (revert)------------
:: ----------------------------------------------------------
echo --- Disable Messaging Service (revert)
:: Restore per-user "MessagingService" service to its default configuration for all users
:: Restore the service `MessagingService` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'MessagingService'; $defaultStartupMode = 'Manual'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: Restore per-user "MessagingService" service to its default configuration for individual user accounts
:: Restore the service `MessagingService_*` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'MessagingService_*'; $defaultStartupMode = 'Manual'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Disable Windows Push Notifications (revert)--------
:: ----------------------------------------------------------
echo --- Disable Windows Push Notifications (revert)
:: Restore service(s) to default state: `WpnService`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'WpnService'; $defaultStartupMode = 'Automatic'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: Restore per-user "WpnUserService" service to its default configuration for all users
:: Restore the service `WpnUserService` 
:: This operation will not run on Windows versions later than Windows10-1909.
PowerShell -ExecutionPolicy Unrestricted -Command "$versionName = 'Windows10-1909'; $buildNumber = switch ($versionName) { 'Windows11-21H2' { '10.0.22000' }; 'Windows10-MostRecent' { '10.0.19045' }; 'Windows10-22H2' { '10.0.19045' }; 'Windows10-1909' { '10.0.18363' }; 'Windows10-1903' { '10.0.18362' }; default { throw "^""Internal privacy$([char]0x002E)sexy error: No build for maximum Windows '$versionName'"^""; }; }; $maxVersion=[System.Version]::Parse($buildNumber); $ver = [Environment]::OSVersion.Version; $verNoPatch = [System.Version]::new($ver.Major, $ver.Minor, $ver.Build); if ($verNoPatch -gt $maxVersion) { Write-Output "^""Skipping: Windows ($verNoPatch) is above maximum $maxVersion ($versionName)"^""; Exit 0; }; $serviceQuery = 'WpnUserService'; $defaultStartupMode = 'Automatic'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: Restore per-user "WpnUserService" service to its default configuration for individual user accounts
:: Restore the service `WpnUserService_*` 
:: This operation will not run on Windows versions later than Windows10-1909.
PowerShell -ExecutionPolicy Unrestricted -Command "$versionName = 'Windows10-1909'; $buildNumber = switch ($versionName) { 'Windows11-21H2' { '10.0.22000' }; 'Windows10-MostRecent' { '10.0.19045' }; 'Windows10-22H2' { '10.0.19045' }; 'Windows10-1909' { '10.0.18363' }; 'Windows10-1903' { '10.0.18362' }; default { throw "^""Internal privacy$([char]0x002E)sexy error: No build for maximum Windows '$versionName'"^""; }; }; $maxVersion=[System.Version]::Parse($buildNumber); $ver = [Environment]::OSVersion.Version; $verNoPatch = [System.Version]::new($ver.Major, $ver.Minor, $ver.Build); if ($verNoPatch -gt $maxVersion) { Write-Output "^""Skipping: Windows ($verNoPatch) is above maximum $maxVersion ($versionName)"^""; Exit 0; }; $serviceQuery = 'WpnUserService_*'; $defaultStartupMode = 'Automatic'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: Disable Shadow Copy (breaks System Restore and Windows Backup) (revert)
echo --- Disable Shadow Copy (breaks System Restore and Windows Backup) (revert)
:: Restore service(s) to default state: `VSS`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'VSS'; $defaultStartupMode = 'Manual'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------------Disable User Data Storage (revert)------------
:: ----------------------------------------------------------
echo --- Disable User Data Storage (revert)
:: Restore per-user "UnistoreSvc" service to its default configuration for all users
:: Restore the service `UnistoreSvc` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'UnistoreSvc'; $defaultStartupMode = 'Manual'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: Restore per-user "UnistoreSvc" service to its default configuration for individual user accounts
:: Restore the service `UnistoreSvc_*` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'UnistoreSvc_*'; $defaultStartupMode = 'Manual'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----------------Disable Sync Host (revert)----------------
:: ----------------------------------------------------------
echo --- Disable Sync Host (revert)
:: Restore per-user "OneSyncSvc" service to its default configuration for all users
:: Restore the service `OneSyncSvc` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'OneSyncSvc'; $defaultStartupMode = 'Automatic'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: Restore per-user "OneSyncSvc" service to its default configuration for individual user accounts
:: Restore the service `OneSyncSvc_*` 
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceQuery = 'OneSyncSvc_*'; $defaultStartupMode = 'Automatic'; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceQuery -ErrorAction SilentlyContinue; if (!$service) { Write-Warning "^""Service query `"^""$serviceQuery`"^"" did not yield and results. Revert cannot proceed."^""; Exit 1; }; $serviceName = $service.Name; Write-Host "^""Restoring registry settings for service `"^""$serviceName`"^"" to default startup mode `"^""$defaultStartupMode`"^""."^""; <# -- 2. Skip if service info is not found in registry #>; $registryKey = "^""HKLM:\SYSTEM\CurrentControlSet\Services\$serviceName"^""; if (-Not (Test-Path $registryKey)) { Write-Warning "^""`"^""$registryKey`"^"" is not found in registry. Revert cannot proceed."^""; Exit 1; }; <# -- 3. Enable if not already enabled #>; $defaultStartupRegValue = switch ($defaultStartupMode) { 'Boot'      { 0 }; 'System'    { 1 }; 'Automatic' { 2 }; 'Manual'    { 3 }; 'Disabled'  { 4 }; default { Write-Error "^""Error: Unknown startup mode specified: `"^""$defaultStartupMode`"^"". Revert cannot proceed."^""; return; }; }; if ($(Get-ItemProperty -Path "^""$registryKey"^"").Start -eq $defaultStartupRegValue) { Write-Host "^""`"^""$serviceName`"^"" is has already default startup mode: `"^""$defaultStartupMode`"^""."^""; } else { try { Set-ItemProperty $registryKey -Name Start -Value $defaultStartupRegValue -Force; Write-Host "^""Successfully restored `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Could not enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, trying to start it."^""; try { Start-Service -Name $serviceName -ErrorAction Stop; Write-Host 'Service started successfully.'; } catch { Write-Warning "^""Failed to restart service. It will be started after reboot. Error: $($_.Exception.Message)"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: Pause the script to view the final state
pause
:: Restore previous environment settings
endlocal
:: Exit the script successfully
exit /b 0